% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_win_loss.R
\name{gt_plt_winloss}
\alias{gt_plt_winloss}
\title{Add win loss point plot into rows of a \code{gt} table}
\usage{
gt_plt_winloss(
  gt_object,
  column,
  max_wins = 17,
  palette = c("#013369", "#D50A0A", "gray"),
  type = "pill",
  width = max_wins/0.83
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column wherein the winloss plot should replace existing data. Note that the data \emph{must} be represented as a list of numeric values ahead of time.}

\item{max_wins}{An integer indicating the max possible wins, this will be used to add padding if the total wins/losses observed is less than the max. This is useful for mid-season reporting. Defaults to a red, blue, grey palette.}

\item{palette}{A character vector of length 3, specifying the colors for win, loss, tie in that exact order.}

\item{type}{A character string representing the type of plot, either a 'pill' or 'square'}

\item{width}{A numeric indicating the width of the plot in \code{mm}, this can help with larger datasets where data points are overlapping.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_plt_winloss} function takes an existing \code{gt_tbl} object and
adds squares of a specific color and vertical position based on wins/losses.
It is a wrapper around \code{gt::text_transform()}. The column chosen \strong{must} be
a list-column as seen in the example code. The column should also only contain
values of 0 (loss), 0.5 (tie), and 1 (win).
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{#' library(gt)

set.seed(37)
data_in <- dplyr::tibble(
  grp = rep(c("A", "B", "C"), each = 10),
  wins = sample(c(0,1,.5), size = 30, prob = c(0.45, 0.45, 0.1), replace = TRUE)
) \%>\%
  dplyr::group_by(grp) \%>\%
  dplyr::summarize(wins=list(wins), .groups = "drop")

data_in

win_table <- data_in \%>\%
  gt() \%>\%
  gt_plt_winloss(wins)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/jthomasmock/gtExtras/master/images/gt_plt_winloss-ex.png" style="width:60\%;" alt="A table of various win/loss outcomes">
}}
}

\section{Function ID}{

3-1
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar}()},
\code{\link{gt_plt_bar_pct}()},
\code{\link{gt_plt_bar_stack}()},
\code{\link{gt_plt_dist}()},
\code{\link{gt_plt_percentile}()},
\code{\link{gt_plt_point}()},
\code{\link{gt_plt_sparkline}()}
}
\concept{Plotting}
