% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_diverging.R
\name{geom_diverging}
\alias{geom_diverging}
\alias{geom_likert}
\alias{geom_pyramid}
\alias{geom_diverging_text}
\alias{geom_likert_text}
\alias{geom_pyramid_text}
\title{Geometries for diverging bar plots}
\usage{
geom_diverging(
  mapping = NULL,
  data = NULL,
  position = "diverging",
  ...,
  complete = "fill",
  default_by = "total"
)

geom_likert(
  mapping = NULL,
  data = NULL,
  position = "likert",
  ...,
  complete = "fill",
  default_by = "x"
)

geom_pyramid(
  mapping = NULL,
  data = NULL,
  position = "diverging",
  ...,
  complete = NULL,
  default_by = "total"
)

geom_diverging_text(
  mapping = ggplot2::aes(!!!auto_contrast),
  data = NULL,
  position = position_diverging(0.5),
  ...,
  complete = "fill",
  default_by = "total"
)

geom_likert_text(
  mapping = ggplot2::aes(!!!auto_contrast),
  data = NULL,
  position = position_likert(0.5),
  ...,
  complete = "fill",
  default_by = "x"
)

geom_pyramid_text(
  mapping = ggplot2::aes(!!!auto_contrast),
  data = NULL,
  position = position_diverging(0.5),
  ...,
  complete = NULL,
  default_by = "total"
)
}
\arguments{
\item{mapping}{Optional set of aesthetic mappings.}

\item{data}{The data to be displayed in this layers.}

\item{position}{A position adjustment to use on the data for this layer.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}}

\item{complete}{An aesthetic for those unobserved values should be completed,
see \code{\link[=stat_prop]{stat_prop()}}.}

\item{default_by}{Name of an aesthetic determining denominators by default,
see \code{\link[=stat_prop]{stat_prop()}}.}
}
\description{
These geometries are variations of \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}} and
\code{\link[ggplot2:geom_text]{ggplot2::geom_text()}} but provides different set of default values.
}
\details{
\itemize{
\item \code{geom_diverging()} is designed for stacked diverging bar plots, using
\code{\link[=position_diverging]{position_diverging()}}.
\item \code{geom_likert()} is designed for Likert-type items. Using
\code{\link[=position_likert]{position_likert()}} (each bar sums to 100\%).
\item \code{geom_pyramid()} is similar to \code{geom_diverging()} but uses
proportions of the total instead of counts.
}

To add labels on the bar plots, simply use \code{geom_diverging_text()},
\code{geom_likert_text()}, or \code{geom_pyramid_text()}.

All these geometries relies on \code{\link[=stat_prop]{stat_prop()}}.
}
\examples{
library(ggplot2)
ggplot(diamonds) +
  aes(x = clarity, fill = cut) +
  geom_diverging()

ggplot(diamonds) +
  aes(x = clarity, fill = cut) +
  geom_diverging(position = position_diverging(cutoff = 4))

ggplot(diamonds) +
  aes(y = clarity, fill = cut) +
  geom_likert() +
  geom_likert_text()

ggplot(diamonds) +
  aes(y = clarity, fill = cut) +
  geom_likert() +
  geom_likert_text(
    aes(
      label = label_percent_abs(accuracy = 1, hide_below = .10)(
        after_stat(prop)
      ),
      colour = after_scale(hex_bw(.data$fill))
    )
  )

d <- Titanic |> as.data.frame()

ggplot(d) +
  aes(y = Class, fill = Sex, weight = Freq) +
  geom_diverging() +
  geom_diverging_text()

ggplot(d) +
  aes(y = Class, fill = Sex, weight = Freq) +
  geom_pyramid() +
  geom_pyramid_text()
}
