% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histograms.R
\name{plot_histogram}
\alias{plot_histogram}
\title{A histogram of a single variable.}
\usage{
plot_histogram(
  output,
  parameter,
  dimension = 1,
  target = NULL,
  external_target = NULL,
  use_initial_points = TRUE,
  use_weights = TRUE,
  mcmc = FALSE,
  bins = 30,
  xlimits = NULL,
  ylimits = NULL,
  default_title = FALSE
)
}
\arguments{
\item{output}{Output from the SMC or EnK algorithm.}

\item{parameter}{The parameter we wish to histogram.}

\item{dimension}{(optional) The dimension of the parameter we wish to histogram. (default is 1)}

\item{target}{(optional) The index of the target we wish to histogram. (default to all targets)}

\item{external_target}{(optional) The index of the external target to plot. (default is to use all external targets, or to ignore if the column is not present)}

\item{use_initial_points}{(optional) If target is not specified and this argument is TRUE, will add the initial unweighted proposed points to the output to be plotted. (default is TRUE)}

\item{use_weights}{(optional) If FALSE, will ignore particle weights in the histogram. If TRUE, will use the particle weights. (defaults to TRUE)}

\item{mcmc}{(optional) If TRUE, the user is indicating that the output is from an MCMC algorithm. This will set use_initial_points=FALSE and use_weights=FALSE no matter what the user sets these arguments to. (default is FALSE)}

\item{bins}{(optional) Number of bins for the histogram. (default 30)}

\item{xlimits}{(optional) Input of the form c(start,end), which specifies the ends of the x-axis.}

\item{ylimits}{(optional) Input of the form c(start,end), which specifies the ends of the y-axis.}

\item{default_title}{(optional) If TRUE, will provide a default title for the figure. If FALSE, no title is used. (defaults to FALSE)}
}
\value{
A histogram in a ggplot figure.
}
\description{
A histogram of a single variable.
}
