% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data_statistical.R
\name{process_data_statistical}
\alias{process_data_statistical}
\title{Process statistical data}
\usage{
process_data_statistical(
  data,
  from = "from",
  to = "to",
  group = NULL,
  sig = "sig",
  thresh = 0.05
)
}
\arguments{
\item{data}{A DataFrame or tibble containing the input data to be processed.}

\item{from}{A string indicating the column name for the start nodes.}

\item{to}{A string indicating the column name for the end nodes.}

\item{group}{A string indicating the column name for the grouping variable.}

\item{sig}{A string indicating the column name for the significance level.}

\item{thresh}{A single number indicating the significance threshold. Default is 0.05.}
}
\value{
A DataFrame with the preprocessed data that is to be passed to gglyph::geom_glyph().
}
\description{
Prepare statistical data for plotting with gglyph::geom_glyph().
}
\examples{
data(pisa_2022)

# For non-grouped data
processed_data <- process_data_statistical(
  data = pisa_2022,
  from = "from",
  to = "to",
  sig = "sig",
  thresh = 0.05
)

# For grouped data
processed_data <- process_data_statistical(
  data = pisa_2022,
  from = "from",
  to = "to",
  sig = "sig",
  group = "group",
  thresh = 0.05
)
}
