% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph-documentation-with-examples.R
\name{gf_density_2d_filled_interactive}
\alias{gf_density_2d_filled_interactive}
\alias{gf_density_2d_interactive}
\alias{gf_density2d_filled_interactive}
\alias{gf_density2d_interactive}
\title{Interactive 2-demensional density plots}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain. Most users can safely ignore this argument.}

\item{gformula}{A formula with shape \code{y ~ x}. Faceting can be achieved by
including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer.}

\item{tooltip}{A formula specifying a variable for tooltips, or a character vector.}

\item{data_id}{A formula or character vector specifying data identifiers
for interactive selection.}

\item{...}{Additional arguments passed to the underlying geom.}

\item{alpha, color, size, shape, fill, group, stroke}{Aesthetics passed to the geom.}

\item{xlab, ylab, title, subtitle, caption}{Labels for the plot.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{show.help}{Logical. If \code{TRUE}, display some minimal help.}

\item{inherit}{Logical. If \code{TRUE}, inherit aesthetics from previous layers.}

\item{environment}{An environment in which to evaluate the formula.}
}
\value{
A gg object that can be displayed with \code{\link[=gf_girafe]{gf_girafe()}}.
}
\description{
Creates an interactive plot using ggiraph. These functions extend
\code{\link[=gf_density2d]{gf_density2d()}},
\code{\link[=gf_density_2d]{gf_density_2d()}},
\code{\link[=gf_density2d_filled]{gf_density2d_filled()}}, and
\code{\link[=gf_density_2d_filled]{gf_density_2d_filled()}}
with interactive features like tooltips and clickable elements.
}
\section{Additional interactive features}{

\itemize{
\item \code{onclick}: JavaScript code (as character string) executed when clicking elements.
\item Additional ggiraph aesthetics may be available depending on the geom.
}
}

\examples{
faithful |>
  gf_density2d_filled_interactive(
    eruptions ~ waiting,
    tooltip = ~ after_stat(level),
    data_id = ~ after_stat(level),
    show.legend = FALSE
  ) |>
  gf_girafe()

faithful |>
  gf_density2d_interactive(
    eruptions ~ waiting,
    tooltip = ~ after_stat(level),
    data_id = ~ after_stat(level),
    show.legend = FALSE
  ) |>
  gf_girafe()

}
\seealso{
\code{\link[=gf_density_2d_filled]{gf_density_2d_filled()}}, \code{\link[=gf_density_2d]{gf_density_2d()}}, \code{\link[=gf_contour_interactive]{gf_contour_interactive()}},
\code{\link[=gf_girafe]{gf_girafe()}}
}
