% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_arrow.R
\name{continuous_arrow_scales}
\alias{continuous_arrow_scales}
\alias{scale_arrow_head_continuous}
\alias{scale_arrow_fins_continuous}
\alias{scale_arrow_mid_continuous}
\title{Continuous arrow scales}
\usage{
scale_arrow_head_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  generator = arrow_head_wings,
  map_arg = "offset",
  other_args = list(),
  range = c(10, 80),
  transform = "identity",
  guide = "legend"
)

scale_arrow_fins_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  generator = arrow_fins_feather,
  map_arg = "indent",
  other_args = list(),
  range = c(0, 1),
  transform = "identity",
  guide = "legend"
)

scale_arrow_mid_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  generator = arrow_head_wings,
  map_arg = "offset",
  other_args = list(),
  range = c(10, 80),
  transform = "identity",
  guide = "legend"
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{labels}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{generator}{A \verb{<function>} that can create an arrow ornament, such
as \link[=arrow_ornaments]{ornamentation} functions.}

\item{map_arg}{An argument of the \code{generator} function to map input to.}

\item{other_args}{Additional, fixed, arguments to pass to the \code{generator}.}

\item{range}{The range that \code{generator}'s \code{map_arg} may take}

\item{transform}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{transform_<name>}. If
transformations require arguments, you can call them from the scales
package, e.g. \code{\link[scales:transform_boxcox]{scales::transform_boxcox(p = 2)}}.
You can create your own transformation with \code{\link[scales:new_transform]{scales::new_transform()}}.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
}
\value{
A \verb{<Scale>} that can be added to a plot.
}
\description{
These scales can map continuous input to an argument of an arrow generator.
The arrow head, arrow fins and middle arrows have separate scales and
by default use different generators.
}
\examples{
base <- ggplot(whirlpool(5), aes(x, y, colour = group)) +
  coord_fixed()

p <- base +
  geom_arrow(
    aes(arrow_head = as.integer(group)),
    length_head = 10
  )

# A typical scale
p + scale_arrow_head_continuous()

# Change other arguments passed to the generator
p + scale_arrow_head_continuous(other_args = list(inset = 90))

# Using another argument of the generator
p + scale_arrow_head_continuous(name = "inset",  map_arg = "inset")

# Using a different generator
p + scale_arrow_head_continuous(
  generator = arrow_head_line,
  map_arg = "angle",
  range = c(20, 80)
)

# The same goes for other arrow aesthetics, but the `generator()` might
# differ.
base +
  geom_arrow(
    aes(arrow_fins = as.integer(group), arrow_mid = as.integer(group)),
    length_fins = 10, arrow_head = NULL
  ) +
  scale_arrow_fins_continuous(map_arg = "height", range = c(0.1, 1)) +
  scale_arrow_mid_continuous(map_arg = "inset")
}
