% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blc_sm.R
\name{bl_corr}
\alias{bl_corr}
\title{Baseline correction}
\usage{
bl_corr(data, gamma = 0.5, subtract = NULL)
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{gamma}{a \emph{float} object. Correction factor between 0 and 1. 0
results in almost no values being subtracted to the baseline, 1 results in
almost everything except the peaks to be subtracted to the baseline. Default
is 0.5.}

\item{subtract}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}
}
\value{
A \emph{data.frame} object. A data frame of the overall time index,
the x-axis retention time, the y-axis retention time, and the baseline
corrected total intensity values.
}
\description{
\code{bl_corr} performs baseline correction of the intensity values.
}
\details{
This function performs baseline correction and baseline subtraction
for TIC values.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
sm_frame <- smooth(frame, lambda=10)
blc_frame <- bl_corr(sm_frame, gamma=0.5)
plot_chr(blc_frame, title='Baseline Corrected')

}
