% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demoTankModel.R
\name{tankWrapper}
\alias{tankWrapper}
\title{Wrapper function for a rain water tank system model}
\usage{
tankWrapper(data, systemArgs, metrics)
}
\arguments{
\item{data}{list; contains observed daily precipitation and temperature to be used to run the rain water tank system model in a list with entries  \emph{times}, \emph{P}, \emph{Temp}.
Please refer data provided with the package that may be loaded using \code{data(tankDat)} for an example of the expected format of \code{data}.}

\item{systemArgs}{a list; contains the input arguments to the rain water tank system model. The valid fields in the list are:
\itemize{
\item \code{roofArea}: numeric; the roof area in sq.m
\item \code{nPeople}: integer; number of people using water
\item \code{tankVol}: numeric; volume of the tank in L
\item \code{firstFlush}: numeric; first flush depth over roof in mm
\item \code{write.file}: logical; indicates whether output is to be written to file
\item \code{fnam}: string; name of the output file
}}

\item{metrics}{string vector; the metrics of performance of the system model to be reported. The valid strings may be viewed using the function \code{viewTankMetrics()}}
}
\value{
The function returns a list containing the calculated values of the performance metrics specified in \code{metrics} after running the system model.
}
\description{
\code{tankWrapper} is a wrapper function for a rainwater tank system model in foreSIGHT. This function is used in examples in function help files and vignettes.
This function may also be used as an example to create wrapper functions for other system models with scenarios generated using foreSIGHT in \code{R} or other programming languages.
}
\examples{
# view available performance metrics
viewTankMetrics()
# load example climate data to run the system model
data(tankDat)
systemArgs <- list(
  roofArea = 205, nPeople = 1, tankVol = 2400,
  firstFlush = 2.0, write.file = FALSE
)
tankWrapper(tank_obs, systemArgs,
  metrics = c("average daily deficit (L)", "reliability (fraction)")
)
}
\seealso{
\code{runSystemModel}, \code{viewTankMetrics}
}
