% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseSimulatedSeries.R
\name{plotScenarios}
\alias{plotScenarios}
\title{Creates summary plots of the biases in the scenarios}
\usage{
plotScenarios(sim, colMapRange = "default", plotAbs = T, showSD = T)
}
\arguments{
\item{sim}{a list; contains a stochastic simulation or the summary of a stochastic simulation created using the function \code{generateScenarios}}

\item{colMapRange}{a string; may be set to the character \code{"default"} or \code{"full"} or to a numeric vector of length 2.
The argument specifies the range of data spanned in the colormap of the heatmap.
If set to \code{"default"}, the colourmap limits of attributes that are in units of percentage is set to 0\% to 10\%,
and the colourmap limits of the attributes of temperature is set to 0 degrees K to 1 degrees K.
If set to \code{"full"}, the colourmap limits are set to the minimum and maximum values in the data.
If a numeric vector is specified, the colourmap limits are set to the first (minimum) and second (maximum) values in the vector.}

\item{plotAbs}{logical value, defaults to TRUE; determines whether the absolute value of the data is plotted (TRUE), or the raw value (which can be positive/negative) is plotted (FALSE).}

\item{showSD}{logical value, defaults to TRUE; determines whether to plot heat maps showing standard deviation in biases (TRUE), or only mean biases (FALSE).}
}
\value{
The function returns two R plots showing the biases in the targets of the scenarios generated using the function \code{generateScenarios}.
}
\description{
\code{plotScenarios} uses a simulation performed using the function \code{generateScenarios} as input and creates heatmaps that show
the biases in the simulated attributes with respect to the specified target values of the attributes.
The plots show the magnitude (absolute value) of the mean biases, and the standard deviation of biases across replicates. The heatmaps can be used
to evaluate how well the simulated attributes match the specified targets.
The biases are in units of percentage for attributes of variables like precipitation, and in units of degrees K for attributes of temperature.
The function creates two heatmaps that show:
\itemize{
\item{magnitude of the mean biases across all the replicates}
\item{standard deviation of biases across all the replicates}
}
}
\details{
The argument \code{sim} may be a full stochastic simulation generated using the function \code{generateScenarios} or the summary of the stochastic simulation
generated using \code{getSimSummary}
}
\examples{
\dontrun{
# load simulated climates from Scott Creek example 
data('egScottCreekSimStoch')
plotScenarios(sim.stoch)
}
}
\seealso{
\code{createExpSpace}, \code{generateScenarions}, \code{getSimSummary}
}
