% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_system_metrics.R
\name{evaluate_system_metrics}
\alias{evaluate_system_metrics}
\title{Calculates system metrics for and observed and baseline stochastic climates}
\usage{
evaluate_system_metrics(
  sim,
  clim,
  systemModel,
  systemArgs,
  metrics,
  varNames = NULL
)
}
\arguments{
\item{sim}{list; a simulation containing the scenarios generated using the function \code{generateScenarios}.}

\item{clim}{a list; reference climate \cr}

\item{systemModel}{a function; The function runs the system model using climate data in a list as input.
The function is expected to be created by the user for specific system models.}

\item{systemArgs}{a list; containing the input arguments to \code{systemModel}.}

\item{metrics}{a string vector; the names of the performance metrics the \code{systemModel} function returns.}

\item{varNames}{a string vector; containing the names of the climate variables that are extracted from sim and used in system model. If \code{NULL}, then \code{varNames} determined from attribute names in \code{sim$expSpace}.}
}
\value{
a list containing \code{systemPerf_base} and \code{systemPerf_obsClim}, with performance metrics for baseline stochastic climate and observed climate, respectively.
}
\description{
\code{evaluate_system_metrics} runs observed climate and baseline
(unperturbed) stochastic climates through a system model and calculates system metrics for each.
This is used to perform evaluation of stochastic climates using the 'virtual observation' approach.
See example in Section 5.3 of \emph{'Stress-Testing' using *fore*SIGHT: Stochastic simulation} vignette.
}
