% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_split.R
\name{fc_split}
\alias{fc_split}
\title{fc_split}
\usage{
fc_split(
  object,
  var = NULL,
  N = NULL,
  label = NULL,
  text_pattern = "{label}\\n {n} ({perc}\%)",
  perc_total = FALSE,
  sel_group = NULL,
  na.rm = FALSE,
  show_zero = FALSE,
  round_digits = 2,
  trim_trailing_zeros = FALSE,
  just = "center",
  text_color = "black",
  text_fs = 8,
  text_fface = 1,
  text_ffamily = NA,
  text_padding = 1,
  bg_fill = "white",
  border_color = "black",
  width = NA,
  height = NA,
  title = NULL,
  x_title = 0.1,
  text_color_title = "black",
  text_fs_title = 10,
  text_fface_title = 1,
  text_ffamily_title = NA,
  text_padding_title = 0.6,
  bg_fill_title = "#B3D1FF",
  border_color_title = "black",
  width_title = NA,
  height_title = NA,
  offset = NULL
)
}
\arguments{
\item{object}{fc object that we want to split.}

\item{var}{variable column of the database from which it will be splitted.}

\item{N}{Number of rows after the split in case \code{var} is \code{NULL}.}

\item{label}{Vector of characters or vector of expressions with the label of each category in order. It has to have as many elements as categories has the column. By default, it will put the labels of the categories.}

\item{text_pattern}{Character or expression defining the structure that will have the text in each of the boxes. It recognizes \code{label}, \code{n}, \code{N} and \code{perc} within brackets. For default it is \code{"{label}\\n {n} ({perc}\%)"}. If \code{text_pattern} or \code{label} is an expression, the \code{label} is always placed at the beginning of the pattern, followed by a line break where the structure specified by \code{text_pattern} is placed.}

\item{perc_total}{logical. Should percentages be calculated using the total number of rows at the beginning of the flowchart? Default is \code{FALSE}, meaning that they will be calculated using the number at the parent leaf.}

\item{sel_group}{Select the group in which to perform the filter. The default is \code{NULL}. Can only be used if the flowchart has previously been split. If the flowchart has more than one group, it can either be given the full name as it is stored in the \verb{$fc} component (separated by '\\'), or it can be given as a vector with the names of each group to be selected.}

\item{na.rm}{logical. Should missing values of the grouping variable be removed? Default is \code{FALSE}.}

\item{show_zero}{logical. Should the levels of the grouping variable that don't have data be shown? Default is \code{FALSE}.}

\item{round_digits}{Number of digits to round percentages. It is 2 by default.}

\item{trim_trailing_zeros}{Logical value. If \code{TRUE}, allows trailing zeros after the decimal to be trimmed (default is \code{FALSE}).}

\item{just}{Justification for the text: \code{"left"}, \code{"center"} or \code{"right"}. Default is \code{"center"}.}

\item{text_color}{Color of the text. It is \code{"black"} by default.}

\item{text_fs}{Font size of the text. It is 8 by default.}

\item{text_fface}{Font face of the text. It is 1 by default. See the \code{fontface} parameter for \link{gpar}.}

\item{text_ffamily}{Changes the font family of the text. Default is \code{NA}. See the \code{fontfamily} parameter for \link{gpar}.}

\item{text_padding}{Changes the text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill}{Box background color. It is \code{"white"} by default.}

\item{border_color}{Box border color. It is \code{"black"} by default.}

\item{width}{Width of the box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height}{Height of the box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{title}{Add a title box to the split. Default is \code{NULL}. It can only be used when there are only two resulting boxes after the split.}

\item{x_title}{x-coordinate of the title box. Default is \code{0.1} (placed in the left).}

\item{text_color_title}{Color of the title text. It is \code{"black"} by default.}

\item{text_fs_title}{Font size of the title text. It is 8 by default.}

\item{text_fface_title}{Font face of the title text. It is 1 by default. See the \code{fontface} parameter for \link{gpar}.}

\item{text_ffamily_title}{Changes the font family of the title text. Default is \code{NA}. See the \code{fontfamily} parameter for \link{gpar}.}

\item{text_padding_title}{Changes the title text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill_title}{Title box background color. It is \code{"white"} by default.}

\item{border_color_title}{Title box border color. It is \code{"black"} by default.}

\item{width_title}{Width of the title box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height_title}{Height of the title box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{offset}{Amount of space to add to the distance between boxes (in the x coordinate). If positive, this distance will be larger. If negative, it will be smaller. This number has to be at least between 0 and 1 (plot limits) and the resulting x coordinate cannot exceed these plot limits. The default is \code{NULL} (no offset).}
}
\value{
List with the dataset grouped by the splitting variable and the flowchart parameters with the resulting split.
}
\description{
This function allows to split the flowchart in function of the categories of a column of the database. It will generate as many boxes as categories has the column showing in each one the frequency of each category. It will additionally group the database per this column.
}
\examples{
safo |>
  dplyr::filter(!is.na(group)) |>
  as_fc(label = "Randomized patients") |>
  fc_split(group) |>
  fc_draw()

}
