% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.R
\name{phbox_data}
\alias{phbox_data}
\title{Phase Boxplot Data}
\usage{
phbox_data(warp_median, alpha = 0.05, kp = 1)
}
\arguments{
\item{warp_median}{fdawarp object from \link{time_warping} of aligned data using
the median.}

\item{alpha}{quantile value (default=.05, i.e., 95\%).}

\item{kp}{scalar for outlier cutoff (default=1).}
}
\value{
Returns a \code{phbox} object containing:
\itemize{
\item \code{median_x}: median warping function
\item \code{Q1}: First quartile
\item \code{Q3}: Second quartile
\item \code{Q1a}: First quantile based on alpha
\item \code{Q3a}: Second quantile based on alpha
\item \code{minn}: minimum extreme function
\item \code{maxx}: maximum extreme function
\item \code{outlier_index}: indexes of outlier functions
}
}
\description{
This function constructs the phase boxplot.
}
\references{
Xie, W., S. Kurtek, K. Bharath, and Y. Sun  (2016). "A geometric
approach to visualization of variability in functional data." Journal of
the American Statistical Association in press: 1-34.
}
\keyword{alignment}
\keyword{boxplot}
\keyword{internal}
\keyword{srvf}
