% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{kmeans_align}
\alias{kmeans_align}
\title{K-Means Clustering and Alignment}
\usage{
kmeans_align(
  f,
  time,
  K = 1L,
  seeds = NULL,
  centroid_type = c("mean", "medoid"),
  nonempty = 0L,
  lambda = 0,
  showplot = FALSE,
  smooth_data = FALSE,
  sparam = 25L,
  parallel = FALSE,
  alignment = TRUE,
  rotation = FALSE,
  scale = TRUE,
  omethod = c("DP", "RBFGS"),
  max_iter = 50L,
  thresh = 0.01,
  use_verbose = FALSE
)
}
\arguments{
\item{f}{Either a numeric matrix or a numeric 3D array specifying the
functions that need to be jointly clustered and aligned.
\itemize{
\item If a matrix, it must be of shape \eqn{M \times N}. In this case, it is
interpreted as a sample of \eqn{N} curves observed on a grid of size
\eqn{M}.
\item If a 3D array, it must be of shape \eqn{L \times M \times N} and it is
interpreted as a sample of \eqn{N} \eqn{L}-dimensional curves observed on a
grid of size \eqn{M}.
}

If this is multidimensional functional data, it is advised that
\code{rotation==FALSE}}

\item{time}{A numeric vector of length \eqn{M} specifying the grid on which
the curves are evaluated.}

\item{K}{An integer value specifying the number of clusters. Defaults to
\code{1L}.}

\item{seeds}{An integer vector of length \code{K} specifying the indices of the
curves in \code{f} which will be chosen as initial centroids. Defaults to \code{NULL}
in which case such indices are randomly chosen.}

\item{centroid_type}{A string specifying the type of centroid to compute.
Choices are \code{"mean"} or \code{"medoid"}. Defaults to \code{"mean"}.}

\item{nonempty}{An integer value specifying the minimum number of curves per
cluster during the assignment step. Set it to a positive value to avoid the
problem of empty clusters. Defaults to \code{0L}.}

\item{lambda}{A numeric value specifying the elasticity. Defaults to \code{0.0}.}

\item{showplot}{A Boolean specifying whether to show plots. Defaults to
\code{FALSE}.}

\item{smooth_data}{A Boolean specifying whether to smooth data using a box
filter. Defaults to \code{FALSE}.}

\item{sparam}{An integer value specifying the number of box filters applied.
Defaults to \code{25L}.}

\item{parallel}{A Boolean specifying whether parallel mode (using
\code{\link[foreach:foreach]{foreach::foreach()}} and the \strong{doParallel} package) should be activated.
Defaults to \code{FALSE}.}

\item{alignment}{A Boolean specifying whether to perform alignment. Defaults
to \code{TRUE}.}

\item{rotation}{A Boolean specifying whether to perform rotation. Defaults to
to \code{FALSE}.}

\item{scale}{A Boolean specifying whether to scale curves to unit length. Defaults
to \code{TRUE}.}

\item{omethod}{A string specifying which method should be used to solve the
optimization problem that provides estimated warping functions. Choices are
\code{"DP"} or \code{"RBFGS"}. Defaults to \code{"DP"}.}

\item{max_iter}{An integer value specifying the maximum number of iterations.
Defaults to \code{50L}.}

\item{thresh}{A numeric value specifying a threshold on the cost function
below which convergence is assumed. Defaults to \code{0.01}.}

\item{use_verbose}{A Boolean specifying whether to display information about
the calculations in the console. Defaults to \code{FALSE}.}
}
\value{
An object of class \code{fdakma} which is a list containing:
\itemize{
\item \code{f0}: the original functions;
\item \code{q0}: the original SRSFs;
\item \code{fn}: the aligned functions as matrices or a 3D arrays of the same shape
than \code{f0} by clusters in a list;
\item \code{qn}: the aligned SRSFs as matrices or a 3D arrays of the same shape
than \code{f0} separated in clusters in a list;
\item \code{labels}: the cluster memberships as an integer vector;
\item \code{templates}: the centroids in the original functional space;
\item \code{templates.q}: the centroids in SRSF space;
\item \code{distances_to_center}: A numeric vector storing the distances of each
observed curve to its center;
\item \code{gam}: the warping functions as matrices or a 3D arrays of the same shape
than \code{f0} by clusters in a list;
\item \code{qun}: cost function value.
}
}
\description{
This function clusters functions and aligns using the elastic square-root
velocity function (SRVF) framework.
}
\examples{
\dontrun{
  out <- kmeans_align(growth_vel$f, growth_vel$time, K = 2)
}
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using Fisher-Rao metric,
arXiv:1103.3817v2.

Tucker, J. D., Wu, W., Srivastava, A., Generative models for
functional data using phase and amplitude separation, Computational
Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.

Sangalli, L. M., et al. (2010). "k-mean alignment for curve
clustering." Computational Statistics & Data Analysis 54(5): 1219-1233.
}
\keyword{alignment}
\keyword{clustering}
\keyword{srsf}
