% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madLANDSAT.r
\docType{data}
\name{madLANDSAT}
\alias{madLANDSAT}
\title{Rasters of surface reflectance for an eastern portion of Madagascar}
\format{
An object of class \code{SpatRaster} in Universal Trans-Mercator (UTM), Zone 39 North with a WGS84 coordinate system, at 90 m resolution.
}
\source{
United States Geological Survey's \href{https://earthexplorer.usgs.gov}{EarthExplorer}. Also see \href{https://www.usgs.gov/faqs/what-are-band-designations-landsat-satellites}{band definitions}.
}
\description{
Raster layers of surface reflectance from LANDSAT 9 for an eastern portion of Madagascar taken May 21, 2023. Four bands are represented:
\itemize{
\item `band2': Blue (450-510 nm)
\item `band3': Green (530-590 nm)
\item `band4': Red (640-670 nm)
\item `band5': Near-infrared (850-880 nm)
The rasters have been resampled to 90-m resolution to reduce their size, then rescaled to integers in the range 0 to 255.
}
}
\examples{

### vector data

library(sf)

# For vector data, we can use data(*) or fastData(*):
data(madCoast0) # same as next line
madCoast0 <- fastData("madCoast0") # same as previous
madCoast0
plot(st_geometry(madCoast0))

madCoast4 <- fastData("madCoast4")
madCoast4
plot(st_geometry(madCoast4), add = TRUE)

madRivers <- fastData("madRivers")
madRivers
plot(st_geometry(madRivers), col = "blue", add = TRUE)

madDypsis <- fastData("madDypsis")
madDypsis
plot(st_geometry(madDypsis), col = "red", add = TRUE)

### raster data

library(terra)

# For raster data, we can get the file directly or using fastData(*):
rastFile <- system.file("extdata/madElev.tif", package="fasterRaster")
madElev <- terra::rast(rastFile)

madElev <- fastData("madElev") # same as previous two lines
madElev
plot(madElev)

madForest2000 <- fastData("madForest2000")
madForest2000
plot(madForest2000)

madForest2014 <- fastData("madForest2014")
madForest2014
plot(madForest2014)

# multi-layer rasters
madChelsa <- fastData("madChelsa")
madChelsa
plot(madChelsa)

madPpt <- fastData("madPpt")
madTmin <- fastData("madTmin")
madTmax <- fastData("madTmax")
madPpt
madTmin
madTmax


# RGB raster
madLANDSAT <- fastData("madLANDSAT")
madLANDSAT
plotRGB(madLANDSAT, 4, 1, 2, stretch = "lin")

# categorical raster
madCover <- fastData("madCover")
madCover
madCover <- droplevels(madCover)
levels(madCover) # levels in the raster
nlevels(madCover) # number of categories
catNames(madCover) # names of categories table

plot(madCover)
}
\keyword{Madagascar}
\keyword{land}
