% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.r
\name{.rename}
\alias{.rename}
\title{Rename a raster or vector in an existing GRASS session}
\usage{
.rename(from, to, rastOrVect = NULL)
}
\arguments{
\item{from, to}{\code{sources} of the raster or vector to rename.}

\item{rastOrVect}{Either \code{NULL} (default), \code{"raster"}, or \code{"vector"}. This specifies the type of object to be renamed. Partial matching is allowed. If left as \code{NULL} (default), the function will try to identify if the object is a raster or vector, and return an error if there is both a raster and vector of given name. Note that unlike in \strong{R}, \strong{GRASS} can have rasters and vector"s with the same name.}
}
\value{
The function invisibly returns \code{TRUE} if the desired rasters and/or vectors were named, and \code{FALSE} if raster and/or vector to be renamed did not exist in the \code{GRASS} session. Notably, a raster or vector or both are renamed in an existing \code{GRASS} session.
}
\description{
Rename a raster or vector in an existing \strong{GRASS} session.
}
\keyword{internal}
