% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eulerr_options.R
\name{eulerr_options}
\alias{eulerr_options}
\title{Get or set global graphical parameters for eulerr}
\usage{
eulerr_options(...)
}
\arguments{
\item{...}{objects to update the global graphical parameters for \pkg{eulerr}
with.}
}
\value{
This function gets or sets updates in the global environment
that are used in \code{\link[=plot.euler]{plot.euler()}}.
}
\description{
This function provides a means to set default parameters for functions
in eulerr. Query \code{\link[=eulerr_options]{eulerr_options()}} (without any
argument) to see all the available options and read more about
the plot-related ones in \code{\link[grid:gpar]{grid::gpar()}} and \code{\link[graphics:par]{graphics::par()}}.
}
\details{
Currently, the following items will be considered:
\describe{
\item{pointsize}{size in pts to be used as basis for fontsizes and
some margin sizes in the resulting plot}#'
\item{fills}{a list of items \code{fill} and \code{alpha}}
\item{edges}{a list of items \code{col}, \code{alpha}, \code{lex}, \code{lwd}, and \code{lty}}
\item{labels}{a list of items \code{rot},
\code{col}, \code{alpha}, \code{fontsize}, \code{cex}, \code{fontfamily}, \code{fontface},
\code{lineheight}, and \code{font}}
\item{quantities}{a list of items \code{type}, \code{rot},
\code{col}, \code{alpha}, \code{fontsize}, \code{cex}, \code{fontfamily},
\code{lineheight}, and \code{font}}
\item{strips}{\code{col}, \code{alpha}, \code{fontsize}, \code{cex}, \code{fontfamily},
\code{lineheight}, and \code{font}}
\item{legend}{arguments to \code{\link[grid:legendGrob]{grid::legendGrob()}} as well as \code{col}, \code{alpha},
\code{fontsize}, \code{cex}, \code{fontfamily}, \code{lineheight}, and \code{font}}
\item{main}{arguments to \code{\link[grid:grid.text]{grid::textGrob()}}}
\item{padding}{a \code{\link[grid:unit]{grid::unit()}} giving the padding between various
elements in plots from \code{\link[=plot.euler]{plot.euler()}}, which you can change
if you, for instance, want to increase spacing between labels,
quantities, and percentages.}
}
}
\examples{
eulerr_options(edges = list(col = "blue"), fontsize = 10)
eulerr_options(n_threads = 2)
}
\seealso{
\code{\link[=plot.euler]{plot.euler()}}, \code{\link[grid:gpar]{grid::gpar()}}, \code{\link[graphics:par]{graphics::par()}}
}
