% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ernm-gof.R
\name{ernm_gof}
\alias{ernm_gof}
\title{Goodness of fit for ERNM model}
\usage{
ernm_gof(
  models,
  observed_network = NULL,
  stats_formula,
  style = "histogram",
  scales = "fixed",
  print = TRUE,
  n_sim = 10000,
  burnin = 10000,
  interval = 100
)
}
\arguments{
\item{models}{named list of ernm models to be to be compared (can be length 1}

\item{observed_network}{the observed network}

\item{stats_formula}{the formula for the statistics (see \code{\link{ernm-formula}})}

\item{style}{the style of the plot, either 'histogram' or 'boxplot'}

\item{scales}{the scales of the plot, either 'fixed' or 'free'}

\item{print}{whether to print the plot}

\item{n_sim}{the number of simulations to run}

\item{burnin}{the burnin for the MCMC simulation}

\item{interval}{the sampling interval for MCMC simulation}
}
\value{
A list containing goodness-of-fit plots and simulated statistics
}
\description{
Goodness of fit plot for ERNM models, particularly suited for comparing models
}
\details{
Goodness of fit in ERNM is done by comparing simulated networks from the ernm model to
the observed network. If the observed network is typical of the simulated networks
it is considered to be well fit.
}
\examples{
\dontrun{
data(samplike)
fit_basic <- ernm(samplike ~ edges() + nodeCount("group") + nodeMatch("group") | group)
fit_tri <- ernm(samplike ~ edges() + nodeCount("group") + nodeMatch("group") + triangles() | group)

# how well is the triangle term fit?
gof <- ernm_gof(
  list(
    basic = fit_basic,
    with_triangles = fit_tri
  ),
  observed_network = samplike,
  stats_formula = samplike ~ triangles(),
  n_sim = 100
)

# look at the fit over all edgewise shared partners
gof <- ernm_gof(
  list(
    basic = fit_basic,
    with_triangles = fit_tri
  ),
  style="boxplot",
  observed_network = samplike,
  stats_formula = samplike ~ esp(1:10),
  n_sim = 100
)
}

}
