% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HUcalc.R
\name{HUcalc}
\alias{HUcalc}
\title{Computes Habitat Quality, Quantity, and Units}
\usage{
HUcalc(SI.out, habitat.quantity, HSIfunc, ...)
}
\arguments{
\item{SI.out}{is a vector of application-specific suitability indices,
which can be produced from SIcalc.}

\item{habitat.quantity}{is a numeric of habitat size associated with these
suitability indices (i.e., length, area, or volume).}

\item{HSIfunc}{is a function for combination of the suitability indices.}

\item{...}{optional arguments to HSIfunc.}
}
\value{
A vector of habitat quality, habitat quantity, and index
  units (quantity times quality).
}
\description{
\code{HUcalc} computes habitat units given a set of suitability indices,
 a habitat suitability index equation, and habitat quantity.
}
\examples{
#Summarize habitat outcomes based on a vector of two suitability indices
#using multiple combination equations.
HUcalc(c(0.1,1), 100, HSIarimean)
HUcalc(c(0.1,1), 100, HSIgeomean)
HUcalc(c(0.1,1), 100, HSImin)
HUcalc(c(0.1,1), 100, HSIwarimean, c(1,0))
HUcalc(c(0.1,1), 100, HSIwarimean, c(0,1))

#HSIfunc can also represent functions outside of the ecorest package
HUcalc(c(0.1,1), 100, mean)
HUcalc(c(0.1,1), 100, max)

}
\references{
US Fish and Wildlife Service. (1980). Habitat as a basis for environmental assessment.
Ecological Services Manual, 101.

US Fish and Wildlife Service. (1980). Habitat Evaluation Procedures (HEP).
Ecological Services Manual, 102.

US Fish and Wildlife Service. (1981). Standards for the Development of
Habitat Suitability Index Models. Ecological Services Manual, 103.
}
