% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_prepare_nox}
\alias{vd_prepare_nox}
\title{Prepare choice data for analysis (without x being present)}
\usage{
vd_prepare_nox(dt, Af = NULL)
}
\arguments{
\item{dt}{tidy choice data (columns: id, task, alt, p, attributes)}

\item{Af}{(optional) contains a full design matrix (for attribute-based screening), or, more generally, a design matrix used for attribute-based screening}
}
\value{
list containing information for prediction functions
}
\description{
This utility function prepares tidy choice data (without x) for fast data access.
}
\details{
Note: This function is only exported because it makes it easier to tinker with this package.
This function re-arranges choice data for fast access, mainly for demand prediction.
}
\examples{
#Minimal example:
#One attribute with 3 levels, 2 subjects, 3 alternatives, 2 tasks
dt <- structure(list(id = c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 
                            2L, 2L), 
                     task = c(1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L), 
                     alt = c(1L, 2L, 3L, 1L, 2L, 3L, 1L, 2L, 3L, 1L, 2L, 3L), 
                     x = c(1, 0, 2, 1, 0, 1, 2, 3, 1, 1, 0, 1), 
                     p = c(0, 1, 1, 1, 2, 0, 2, 2, 1, 2, 1, 1), 
                     attr2 = c(1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0), 
                     attr1 = c(0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1)), 
                 class = c("tbl_df", "tbl", "data.frame"), row.names = c(NA,-12L))
test <- dt \%>\% dplyr::select(-all_of("x")) \%>\% vd_prepare_nox() 

}
