% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tern.R
\name{tern_summary_table}
\alias{tern_summary_table}
\title{Create a clinical reporting table with tern/rtables}
\usage{
tern_summary_table(dt, target, treat, target_name = target)
}
\arguments{
\item{dt}{A \code{data.frame} containing, at least, the variables indicated in
\code{target} and \code{treat}.}

\item{target}{Target variable passed as a string for which summary
statistics are to be calculated.}

\item{treat}{A string indicating the grouping variable, e.g. the variable
specifying the treatment population.}

\item{target_name}{Heading for the target variable as a string. Defaults to
\code{target}.}
}
\value{
A \code{data.table} of summary statistics. The format depends on the
type of the \code{target} variable:
\itemize{
\item If the \code{target} variable is categorical, i.e. type \code{character}, \code{factor}
or \code{logical} then the output is that of \code{\link[=calc_counts]{calc_counts()}}.
\item If the \code{target} variable is numeric, then the output is that of
\code{\link[=calc_desc]{calc_desc()}}.
}
}
\description{
\code{\link[=tern_summary_table]{tern_summary_table()}} is a convenience wrapper around \code{{rtables}} and
\code{{tern}} commands to generate a clinical reporting summary statistics tables
whilst using a similar interface as \code{\link[=summary_table]{summary_table()}}. This can be helpful
for side by side comparisons of the two functions.
}
\examples{
dmg_vars <- c("AGE", "RACE", "ETHNIC")
dmg_var_lbls <- c("Age (yr)", "Race", "Ethnicity")

# Demographics table (DMT01)
tern_summary_table(
  adsl,
  target = dmg_vars,
  treat = 'ARM',
  target_name = dmg_var_lbls
)

# Demographics table (DMT01) with continuous variable (e.g., BMRKR1)
tern_summary_table(
  adsl,
  target = c(dmg_vars, "BMRKR1"),
  treat = 'ARM',
  target_name = c(dmg_var_lbls, "Biomarker 1")
)

}
\seealso{
\code{\link[=summary_table]{summary_table()}}
}
