% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-stats.R
\name{calc_counts}
\alias{calc_counts}
\title{Calculate counts of a categorical variable}
\usage{
calc_counts(
  dt,
  target,
  target_name = target,
  treat,
  indent = nbsp(n = 4L),
  .total_dt = NULL,
  pct_dec = 1
)
}
\arguments{
\item{dt}{A \code{data.frame} containing, at least, the variables indicated in
\code{target} and \code{treat}.}

\item{target}{Target variable passed as a string for which summary
statistics are to be calculated.}

\item{target_name}{Heading for the target variable as a string. Defaults to
\code{target}.}

\item{treat}{A string indicating the grouping variable, e.g. the variable
specifying the treatment population.}

\item{indent}{A string to be used as indentation of summary statistics
labels. Defaults to four HTML non-breaking spaces (\verb{&nbsp;}).}

\item{.total_dt}{Separate table from \code{dt} from which to derive total counts
per group.}

\item{pct_dec}{This argument is ignored, and is only kept for backward
compatibility reasons.}
}
\value{
A list containing a \code{data.table} formatted as follows:
\itemize{
\item First column is named \code{stats} and contains the target variable name
indicated in \code{target} in the first row. Subsequent rows contain the
levels of \code{target}.
\item Other columns are for the levels of the grouping variable (\code{treat}).
\item All columns are of character type.
}

This table is structured for easy integration with Shiny output widgets.
}
\description{
\code{\link[=calc_counts]{calc_counts()}} counts observations of a categorical variable (\code{target}) by
another (\code{treat}) and reports summary statistics in clinical trial reporting
format.
}
\examples{
calc_counts(dt = adsl, "RACE", treat = "ARM", indent = "  ")[[1]]

}
