% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_labels.R
\name{get_labels}
\alias{get_labels}
\title{Get labels for items}
\usage{
get_labels(items = NULL, trim = NULL, itemtable = NULL)
}
\arguments{
\item{items}{A character vector of item names to return. The
default (\code{NULL}) returns the labels of all items.}

\item{trim}{The maximum number of characters in the label. The
default \code{trim = NULL} does not trim labels.}

\item{itemtable}{A \code{data.frame} set up according to the
same structure as \code{\link[=builtin_itemtable]{builtin_itemtable()}}. If not specified,
the \code{builtin_itemtable} is used.}
}
\value{
A named character vector with \code{length(items)} elements with
item labels, in the same order as in \code{items}.
}
\description{
The \code{get_labels()} function obtains the item labels for a
specified set of items.
}
\examples{
# get labels of first two Macarthur items
get_labels(get_itemnames(instrument = "mac", number = 1:2), trim = 40)
}
\seealso{
\code{\link[=builtin_itemtable]{builtin_itemtable()}}, \code{\link[=get_itemnames]{get_itemnames()}}
}
