% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_helpers.R
\name{extract_threshold_effect}
\alias{extract_threshold_effect}
\title{Compute difference in average outcomes above and below a dose threshold.}
\usage{
extract_threshold_effect(z, r, threshold)
}
\arguments{
\item{z}{a vector of doses}

\item{r}{a vector of outcomes}

\item{threshold}{a dose threshold}
}
\value{
the average of the outcomes with dose z above threshold c minus the
average of the outcomes with dose z below the threshold c.
}
\description{
Compute difference in average outcomes above and below a dose threshold.
}
\examples{
# dose vector
dose <- c(0, 0.1, 0.4)
# outcome vector
outcome <- c(1, 1.1, 1.5)
theta <- extract_threshold_effect(z = dose, r = outcome, threshold = 0.3)
}
