% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDeFinetti.r
\name{plotDeFinetti}
\alias{plotDeFinetti}
\title{Plot the De Finetti Diagram for Polarized Genotypes}
\usage{
plotDeFinetti(
  genotypes,
  cols,
  HWE = TRUE,
  tipLabels = c("Homozygous 0", "Heterozygous 1", "Homozygous 2"),
  ...
)
}
\arguments{
\item{genotypes}{A character matrix with _012 encoding of genotypes. Rows represent
individuals, columns represent markers.}

\item{cols}{A character vector of colors with a length equal to the number of
individuals (rows) in \code{genotypes}.}

\item{HWE}{Logical indicating whether to plot the curve for Hardy-Weinberg Equilibrium.}

\item{tipLabels}{A character vector of length 3 with names for the ternary plot vertices.}

\item{...}{additional graphical parameters (see \link[graphics]{plot.default}).}
}
\value{
No return value; the function is called for its side effects.
}
\description{
This function calculates genotype frequencies from polarized genotypes, ideally
imported using the
\code{importPolarized} function. It plots individuals onto a ternary De Finetti
diagram and includes a curve indicating Hardy-Weinberg equilibrium if specified.
}
\details{
To import and polarize genotypes, use the \link{importPolarized} function.
Alternatively, the I4 matrix can be used as input for \code{genotypes}.
}
\examples{
gen <- importPolarized(
  file = system.file("extdata", "data7x10.txt", package = "diemr"),
  changePolarity = c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE),
  ChosenInds = 1:7
)

plotDeFinetti(gen, cols = palette.colors(nrow(gen), "Accent"), pch = 19)
}
