% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delim_autoplot2.R
\name{delim_autoplot2}
\alias{delim_autoplot2}
\title{Plot Phylogenetic Trees With Species Delimitation Partitions}
\usage{
delim_autoplot2(
  delim,
  tr,
  consensus = TRUE,
  n_match = NULL,
  delim_order = NULL,
  tbl_labs,
  species,
  hexpand = 0.1,
  widths = c(0.5, 0.2)
)
}
\arguments{
\item{delim}{Output from \link{delim_join}.}

\item{tr}{A \link[tidytree:treedata-class]{treedata} object. Both phylogram and
ultrametric trees are supported.}

\item{consensus}{Logical. Should the majority-vote consensus to be estimated?}

\item{n_match}{An Integer. If \code{consensus = TRUE}, threshold for majority-vote
calculations. See \link{delim_consensus} for details.}

\item{delim_order}{A character vector of species delimitation names ordered by user.
Default to NULL.}

\item{tbl_labs}{A \link[tibble:tbl_df-class]{tbl_df} of customized labels for tree plotting. The
first column must match tip labels of the \code{tr} object, while the second column
should have customized labels.}

\item{species}{column name in \code{tbl_labs} which contains species names for each tip of the tree.}

\item{hexpand}{Numeric. Expand xlim of tree by a ratio of x axis range. Useful if
tiplabels become truncated when plotting. Default to \code{0.1}.}

\item{widths}{A numeric vector containing the relative widths of the tree and
species delimitation bars. See \link[patchwork:wrap_plots]{wrap_plots} for details.
Defaults to \code{c(0.5, 0.2)}.}
}
\value{
A \code{patchwork} object.
}
\description{
\code{delim_autoplot2()} returns a phylogenetic tree plotted using \code{ggtree} alongside
with a customized tile plot using \link[ggplot2:geom_tile]{geom_tile} combined by
\link[patchwork:wrap_plots]{wrap_plots}.
}
\details{
\code{delim_autoplot2()} is a wrapper for tree plotting with associated data implemented
using \code{ggtree}, \code{ggplot2}, and \code{patchwork}. If \code{consensus = TRUE}, a consensus bar will be plotted next to the species delimitation plot,
summarizing partitions across samples. If no consensus is reached, an "X" will be plotted instead.
This function is a modified version of \link{delim_autoplot} which plots
species partitions using a black and grey color scheme.
}
\examples{
# create labels
labs <- geophagus_info |> dplyr::select(gbAccession, scientificName)

# view partitions using an ultrametric tree
p <- delim_autoplot2(geophagus_delims,
  geophagus_beast,
  tbl_labs = labs,
  species = "scientificName"
)
p

# view partitions using a phylogram
p1 <- delim_autoplot2(geophagus_delims,
  geophagus_raxml,
  tbl_labs = labs,
  species = "scientificName"
)

}
\author{
Pedro S. Bittencourt, Rupert A. Collins.
}
