% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionDatasets.R
\name{GetPredictionDataset}
\alias{GetPredictionDataset}
\title{Retrieve data on a prediction dataset}
\usage{
GetPredictionDataset(project, datasetId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{datasetId}{character. The ID of the prediction dataset.}
}
\value{
Data for a particular prediction dataset:
\itemize{
  \item id character. The unique alphanumeric identifier for the dataset.
  \item numColumns numeric. Number of columns in dataset.
  \item name character. Name of dataset file.
  \item created character. time of upload.
  \item projectId character. String giving the unique alphanumeric identifier for the project.
  \item numRows numeric. Number of rows in dataset.
  \item forecastPoint. The point relative to which predictions will be generated, based on the
    forecast window of the project. Only specified in time series projects, otherwise
    will be NULL.
}
}
\description{
Retrieve data on a prediction dataset
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  datasetId <- "5cd36e6e77a90f79a28ba414"
  GetPredictionDataset(projectId, datasetId)
}
}
