% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\name{serializeToBagIt}
\alias{serializeToBagIt}
\alias{serializeToBagIt,DataPackage-method}
\title{Serialize A DataPackage into a BagIt Archive File}
\usage{
serializeToBagIt(x, ...)

\S4method{serializeToBagIt}{DataPackage}(
  x,
  mapId = NA_character_,
  syntaxName = NA_character_,
  namespaces = data.frame(),
  mimeType = NA_character_,
  syntaxURI = NA_character_,
  resolveURI = NA_character_,
  creator = NA_character_,
  ...
)
}
\arguments{
\item{x}{A DataPackage object}

\item{...}{Additional arguments}

\item{mapId}{A unique identifier for the package resource map. If not specified, one will be automatically generated.}

\item{syntaxName}{The name of the syntax to use for the resource map serialization, defaults to "rdfxml"}

\item{namespaces}{An optional data frame containing one or more namespaces and their associated prefix for the resource map serialization.}

\item{mimeType}{The mimetype for the resource map serialization, defaults to "application/rdf+xml".}

\item{syntaxURI}{An optional string specifying the URI for the resource map serialization.}

\item{resolveURI}{A character string containing a URI to prepend to datapackage identifiers for the resource map.}

\item{creator}{A \code{character} string containing the creator of the package.}
}
\value{
The file name that contains the BagIt zip archive.
Recursively determines the name for a science metadata object.
The base file name (eml, datacite, science-metadata, etc) should stay the same.
Call the method with the base name and the number of existing files to start with.
This is most likely 0.
If there's a count defined, add it to the end of the file in ()
Then call the method again with count += 1
Eventually a free file name will be found, and then the function returns that name
}
\description{
The BagIt packaging format \url{https://datatracker.ietf.org/doc/html/draft-kunze-bagit-08}
    is used to prepare an archive file that contains the contents of a DataPackage.
}
\details{
A BagIt Archive File is created by copying each member of a DataPackage, and preparing
    files that describe the files in the archive, including information about the size of the files
    and a checksum for each file. An OAI-ORE resource map is automatically created and added to the
    archive. These metadata files and the data files are then packaged into
    a single zip file.
}
\examples{
# Create the first data object
dp <- new("DataPackage")
data <- charToRaw("1,2,3,5,6")
do <- new("DataObject", id="do1", dataobj=data, format="text/csv", user="jsmith")
dp <- addMember(dp, do)
# Create a second data object
data2 <- charToRaw("7,8,9,4,10,11")
do2 <- new("DataObject", id="do2", dataobj=data2, format="text/csv", user="jsmith")
dp <- addMember(dp, do2)
# Create a relationship between the two data objects
dp <- describeWorkflow(dp, sources="do2", derivations="do2")
# Write out the data package to a BagIt file
\dontrun{
bagitFile <- serializeToBagIt(dp, syntaxName="json", mimeType="application/json")
}
}
\seealso{
\code{\link{DataPackage-class}}

For more information and examples regarding the parameters specifying the creation of the resource map, see \link{serializePackage}.
}
