% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getAccrual}
\alias{getAccrual}
\title{Get Accrual}
\usage{
getAccrual(
  numsubjects,
  ppm,
  follow.up = 0,
  cont.recruit = FALSE,
  perpetual = FALSE
)
}
\arguments{
\item{numsubjects}{Maximum sample size. If perpetual is TRUE, a new maximum sample size is returned.}

\item{ppm}{Patients accrued per month, as an array. Length of array is the number of months in the trial.}

\item{follow.up}{Follow-up period in months.}

\item{cont.recruit}{Whether to continue recruitment while waiting for follow up (TRUE) of not (FALSE).}

\item{perpetual}{Whether to run trial perpetually (TRUE) or not (FALSE).}
}
\value{
Vector size of number of patients you need to get 'numsubjects' followup with values representing month of accrual.
}
\description{
Generate patient accrual with Poisson distribution.
}
\examples{
ppm <- rep(15, 300)
monthin <- getAccrual(1000, ppm, 0)
# monthin is of length 1000.
}
