% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condor_log.R
\name{condor_log}
\alias{condor_log}
\title{Condor Log}
\usage{
condor_log(run.dir = ".", top.dir = "condor", local.dir = NULL,
  session = NULL)
}
\arguments{
\item{run.dir}{name of a Condor run directory inside \code{top.dir}.}

\item{top.dir}{top directory on submitter machine that contains Condor run
directories.}

\item{local.dir}{local directory to examine instead of
\emph{top.dir}\code{/}\emph{run.dir}.}

\item{session}{optional object of class \code{ssh_connect}.}
}
\value{
Log file contents as an object of class \code{condor_log}.

The \code{condor_log} class is simply a \code{"character"} vector with a
\code{print.condor_log} method.
}
\description{
Show Condor log file from a run directory, either on submitter machine or on
a local drive.
}
\details{
The default value of \code{session = NULL} looks for a \code{session} object
in the user workspace. This allows the user to run Condor functions without
explicitly specifying the \code{session}.
}
\examples{
\dontrun{

# Examine log files on submitter machine
session <- ssh_connect("servername")

condor_dir()
condor_log()
summary(condor_log())

# Alternatively, examine log file on local drive
condor_dir(local.dir="c:/myruns")
condor_log(local.dir="c:/myruns/01_this_model")
summary(condor_log(local.dir="c:/myruns/01_this_model"))
}

}
\seealso{
\code{\link{summary.condor_log}} shows Condor log file summary.

\code{\link{condor_dir}} lists Condor directories.

\code{\link{condor-package}} gives an overview of the package.
}
\author{
Arni Magnusson.
}
