% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{scale_numeric}
\alias{scale_numeric}
\title{scales a numeric vector}
\usage{
scale_numeric(x, xmin = min(x, na.rm = TRUE), xmax = max(x, na.rm = TRUE))
}
\arguments{
\item{x}{the numeric vector to scale}

\item{xmin}{the minimum value used for the scaling. all all x < xmin are set to 0}

\item{xmax}{the maximum value used for the scaling. all x > xmax set to 1}
}
\value{
a numeric vector of the same length as x, with all values between 0 and 1, except for NAs which are unchanged
}
\description{
scales a numeric vector
}
\examples{
x <- c(0.1, 100, -2.5, 20, 78.2, NA)
scaled <- scale_numeric(x)
all(is.na(scaled) | (scaled >= 0 & scaled <= 1))
}
