% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.clarify_adrf.R
\name{plot.clarify_adrf}
\alias{plot.clarify_adrf}
\title{Plot marginal predictions from \code{sim_adrf()}}
\usage{
\method{plot}{clarify_adrf}(
  x,
  ci = TRUE,
  level = 0.95,
  method = "quantile",
  baseline = NULL,
  color = "black",
  simultaneous = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{clarify_adrf} object resulting from a call to \code{\link[=sim_adrf]{sim_adrf()}}.}

\item{ci}{\code{logical}; whether to display confidence bands for the estimates. Default is \code{TRUE}.}

\item{level}{the confidence level desired. Default is .95 for 95\% confidence intervals.}

\item{method}{the method used to compute confidence bands. Can be \code{"wald"} to use a Normal approximation or \code{"quantile"} to use the simulated sampling distribution (default). See \code{\link[=summary.clarify_est]{summary.clarify_est()}} for details. Abbreviations allowed.}

\item{baseline}{\code{logical}; whether to include a horizontal line at \code{y = 0} on the plot. Default is \code{FALSE} for the ADRF (since 0 might not be in the range of the outcome) and \code{TRUE} for the AMEF.}

\item{color}{the color of the line and confidence band in the plot.}

\item{simultaneous}{\code{logical}; whether confidence bands should be simultaneous or not (i.e., for nominal coverage of the whole effect curve); default is \code{FALSE}, but \code{TRUE} is recommended. See Details at \code{\link[=summary.clarify_est]{summary.clarify_est()}} for details.}

\item{...}{for \code{plot()}, further arguments passed to \code{\link[ggplot2:geom_density]{ggplot2::geom_density()}}.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{plot.clarify_adrf()} plots the output of \code{\link[=sim_adrf]{sim_adrf()}}. For the average dose-response function (ADRF, requested with \code{contrast = "adrf"} in \code{sim_adrf()}), this is a plot of the average marginal mean of the outcome against the requested values of the focal predictor; for the average marginal effects function (AMEF, requested with \code{contrast = "amef"} in \code{sim_adrf()}), this is a plot of the instantaneous average marginal effect of the focal predictor on the outcome against the requested values of the focal predictor.
}
\details{
These plots are produced using \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}} and \code{\link[ggplot2:geom_ribbon]{ggplot2::geom_ribbon()}}. The confidence bands should be interpreted pointwise (i.e., they do not account for simultaneous inference) unless \code{simultaneous = TRUE}.
}
\examples{
## See help("sim_adrf") for examples
}
\seealso{
\code{\link[=summary.clarify_est]{summary.clarify_est()}} for computing p-values and confidence intervals for the estimated quantities.
}
