% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{random_population}
\alias{random_population}
\title{Random population initialization}
\usage{
random_population(popSize, prange, N, minDist, pchangepoint, mmax, lmax)
}
\arguments{
\item{popSize}{An integer represents the number of individual in each
population for GA (or subpopulation for IslandGA).}

\item{prange}{Default is \code{NULL} for only changepoint detection. If
\code{prange} is specified as a list object, which contains the range of
each model order parameters for order selection (integers). The number of
order parameters must be equal to the length of \code{prange}.}

\item{N}{The length of time series.}

\item{minDist}{The minimum length between two adjacent changepoints.}

\item{pchangepoint}{Same as \code{pchangepoint} from \code{\link{cptga}} or 
\code{\link{cptgaisl}}, the probability that a changepoint has occurred.}

\item{mmax}{The maximum possible number of changepoints in the data set.}

\item{lmax}{The maximum possible length of the chromosome representation.}
}
\value{
A matrix that contains each individual's chromosome.
}
\description{
Randomly generate the individuals' chromosomes (changepoint confirgurations)
to construct the first generation population.
}
\details{
Each population can be stored in a matrix with \code{lmax} rows and 
\code{popSize} columns, where each column represents an individual chromosome
in the format of
\deqn{C = (m, \boldsymbol{s}, \boldsymbol{\tau}, N+1)',} 
in \code{\link{cptga}} or \code{\link{cptgaisl}}. This function can randomly 
initialize the population matrix with some imposed constraints, such as 
ensuring the number of time points between two adjacent changepoints is 
greater than or equal to \code{minDist}. This prevents unrealistic scenario 
of two changepoints being too close to each other and helps reduce the total 
number of admissible solutions in the search space. Users can adjust the 
level of searching space reduction by setting an appropriate value for 
\code{minDist}. During population initialization, each changepoint location 
in \eqn{\boldsymbol{\tau}} can be selected sequentially. With a specified 
probability \code{pchangepoint} denoting the probability of a time point 
being selected as a changepoint, the first changepoint \eqn{\tau_{1}} is 
randomly picked between \eqn{t=1+minDist} and \eqn{t=N}. Then \eqn{\tau_{2}} 
is randomly selected from a smaller range between \eqn{t=\tau_{1}+minDist} 
and \eqn{t=N}. The process is continued until the last admissible changepoint 
\eqn{t=N-minDist} is exceeded, and the number of changepoints \eqn{m} is 
obtained automatically. For added flexibility, users can specify their own 
population initialization function. The default population initialization uses 
\code{\link{selectTau}} to select the chromosome for the first generation 
population.
}
