% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_deconv.R
\name{plot_tune}
\alias{plot_tune}
\title{Plot tuning curves}
\usage{
plot_tune(
  result,
  group = "subclass",
  xvar = colnames(result)[1],
  fix = NULL,
  metric = attr(result, "metric"),
  title = NULL
)
}
\arguments{
\item{result}{Dataframe of tuning results generated by \code{\link[=tune_deconv]{tune_deconv()}}.}

\item{group}{Character value specifying column in \code{result} to be grouped by
colour; or \code{NULL} to average R-squared/RMSE values across the grid and show
the generalised mean effect of varying the parameter specified by \code{xvar}.}

\item{xvar}{Character value specifying column in \code{result} to vary along the x
axis.}

\item{fix}{Optional list specifying parameters to be fixed at specific values.}

\item{metric}{Specifies tuning metric: either "RMSE", "Rsq" or "pearson".}

\item{title}{Character value for the plot title.}
}
\value{
ggplot2 scatter plot.
}
\description{
Produces a ggplot2 plot of R-squared/RMSE values generated by
\code{\link[=tune_deconv]{tune_deconv()}}.
}
\details{
If \code{group} is set to \code{"subclass"}, then the tuning parameter specified by
\code{xvar} is varied on the x axis. Any other tuning parameters (i.e. if 2 or
more have been tuned) are fixed to their best tuned values.

If \code{group} is set to a different column than \code{"subclass"}, then the mean
R-squared/RMSE values in \code{result} are averaged over subclasses. This makes it
easier to compare the overall effect (mean R-squared/RMSE) of 2 tuned
parameters which are specified by \code{xvar} and \code{group}. Any remaining
parameters not shown are fixed to their best tuned values.

If \code{group} is \code{NULL}, the tuning parameter specified by \code{xvar} is varied on
the x axis and R-squared/RMSE values are averaged over the whole grid to give
the generalised mean effect of varying the \code{xvar} parameter.
}
