% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_bulk.R
\name{metric_set}
\alias{metric_set}
\title{Calculate R-squared and metrics on deconvoluted cell subclasses}
\usage{
metric_set(obs, pred)
}
\arguments{
\item{obs}{Observed matrix of cell amounts with subclasses in columns and
samples in rows.}

\item{pred}{Predicted (deconvoluted) matrix of cell amounts with rows and
columns matching \code{obs}.}
}
\value{
Matrix containing Pearson r-squared, R-squared and RMSE values.
}
\description{
Calculates Pearson r-squared, R-squared and RMSE comparing subclasses in each
column of \code{obs} with matching columns in deconvoluted \code{pred}. Samples are in
rows. For use if ground truth is available, e.g. simulated pseudo-bulk
RNA-Seq data.
}
\details{
Pearson r-squared ranges from 0 to 1. R-squared, calculated as 1 - rss/tss,
ranges from -Inf to 1.
}
