% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convo_get_log.R
\name{bs_get_convo_log}
\alias{bs_get_convo_log}
\title{Retrieve the chat event log for the authenticated user}
\usage{
bs_get_convo_log(
  cursor = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{cursor}{Character, length 1. A cursor property from a prior response. Default: \code{NULL}.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} or a \code{list} if \code{clean = FALSE}
}
\description{
Retrieve the chat event log for the authenticated user
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/chat/bsky/convo/getLog.json}{chat.bsky.convo.getLog.json (2025-05-16)}
}

\section{Function introduced}{

\code{v0.4.0} (2025-05-16)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_get_convo_log()
\dontshow{\}) # examplesIf}
}
\concept{chat}
