% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Boredom}
\alias{Boredom}
\title{Short Boredom Proneness Scale Responses}
\format{
A matrix with 986 rows and 9 columns. Each row corresponds to a respondent.
\describe{
  \item{language}{Language in which the SBPS was administered: "en" = English, "fr" = French}
  \item{loose_ends}{I often find myself at “loose ends,” not knowing what to
  do.}
  \item{entertain}{I find it hard to entertain myself.}
  \item{repetitive}{Many things I have to do are repetitive and monotonous.}
  \item{stimulation}{It takes more stimulation to get me going than most
  people.}
  \item{motivated}{I don't feel motivated by most things that I do.}
  \item{keep_interest}{In most situations, it is hard for me to find
  something to do or see to keep me interested.}
  \item{sit_around}{Much of the time, I just sit around doing nothing.}
  \item{half_dead_dull}{Unless I am doing something exciting, even dangerous,
  I feel half-dead and dull.}
}
}
\source{
\insertCite{Martarelli_2023_Boredom;textual}{bgms}.
Data retrieved from \url{https://osf.io/qhux8}.
Licensed under the CC-BY 4.0: https://creativecommons.org/licenses/by/4.0/
}
\usage{
data("Boredom")
}
\description{
This dataset includes responses to the 8-item Short Boredom Proneness Scale (SBPS),
a self-report measure of an individual's susceptibility to boredom
\insertCite{Martarelli_2023_Boredom}{bgms}. Items were rated on a 7-point Likert scale
ranging from 1 ("strongly disagree") to 7 ("strongly agree"). The scale was administered
in either English \insertCite{Struk_2015_boredom}{bgms} or French (translated by \insertCite{Martarelli_2023_Boredom}{bgms}).
}
\references{
\insertAllCited{}
}
\keyword{datasets}
