% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-beta-nb.R
\name{BetaNB}
\alias{BetaNB}
\title{Estimate Standardized Regression Coefficients
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
BetaNB(object, alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{nb}, that is,
the output of the \code{NB()} function.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{thetahatstar}{Sampling distribution of
\eqn{\boldsymbol{\hat{\beta}}}.}
\item{jackknife}{Jackknife estimates.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{\boldsymbol{\hat{\beta}}}.}
\item{est}{Vector of estimated
\eqn{\boldsymbol{\hat{\beta}}}.}
\item{fun}{Function used ("BetaNB").}
}
}
\description{
Estimate Standardized Regression Coefficients
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
The vector of standardized regression coefficients
(\eqn{\boldsymbol{\hat{\beta}}})
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{\boldsymbol{\hat{\beta}}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Data ---------------------------------------------------------------------
data("nas1982", package = "betaNB")

# Fit Model in lm ----------------------------------------------------------
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)

# NB -----------------------------------------------------------------------
nb <- NB(
  object,
  R = 100, # use a large value e.g., 5000L for actual research
  seed = 0508
)

# BetaNB -------------------------------------------------------------------
out <- BetaNB(nb, alpha = 0.05)

## Methods -----------------------------------------------------------------
print(out)
summary(out)
coef(out)
vcov(out)
confint(out, level = 0.95)

}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{DeltaRSqNB}()},
\code{\link{DiffBetaNB}()},
\code{\link{NB}()},
\code{\link{PCorNB}()},
\code{\link{RSqNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{std}
