% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{n_draw.bage_mod}
\alias{n_draw.bage_mod}
\title{Get the Number of Draws for a  Model Object}
\usage{
\method{n_draw}{bage_mod}(x)
}
\arguments{
\item{x}{An object of class \code{"bage_mod"},
created using \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}},
or \code{\link[=mod_norm]{mod_norm()}}.}
}
\value{
An integer
}
\description{
Get the value of \code{n_draw} for a model object.
\code{n_draw} controls the number
of posterior draws that are generated
by functions such as \code{\link[=augment]{augment()}}
and \code{\link[=components]{components()}}.
}
\examples{
mod <- mod_pois(injuries ~ age:sex + ethnicity + year,
                data = nzl_injuries,
                exposure = popn)
n_draw(mod)
mod <- mod |>
  set_n_draw(n_draw = 5000)
n_draw(mod)
}
\seealso{
\itemize{
\item \code{\link[=set_n_draw]{set_n_draw()}} Modify the value of \code{n_draw}
\item \code{\link[=mod_pois]{mod_pois()}},\code{\link[=mod_binom]{mod_binom()}},\code{\link[=mod_norm]{mod_norm()}} Create a model object
}
}
