% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-open.R
\name{arc_open}
\alias{arc_open}
\title{Access a Data Service or Portal Item}
\usage{
arc_open(url, host = arc_host(), token = arc_token())
}
\arguments{
\item{url}{a url to a service such as a feature service, image server, or map server. Alternatively, an item ID of a portal item or portal url.}

\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}
}
\value{
Depending on item ID or URL returns a \code{PortalItem}, \code{FeatureLayer}, \code{Table}, \code{FeatureServer}, \code{ImageServer}, or \code{MapServer}, \code{GeocodeServer}, among other. Each of these objects is a named list containing the properties of the service.
}
\description{
Access a resource on ArcGIS Online, Enterprise, or Location Platform.
}
\details{
\itemize{
\item To read the underlying attribute data from a \code{FeatureLayer}, \code{Table}, or \code{ImageServer} use \code{\link[=arc_select]{arc_select()}}.
\item If you have a \code{MapServer} or \code{FeatureSever} access the individual layes using \code{\link[=get_layer]{get_layer()}}. For
\item Use \code{\link[=arc_raster]{arc_raster()}} to get imagery as a terra raster object.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
\dontrun{

# FeatureServer ID
arc_open("3b7221d4e47740cab9235b839fa55cd7")

# FeatureLayer
furl <- paste0(
  "https://services3.arcgis.com/ZvidGQkLaDJxRSJ2/arcgis/rest/services/",
  "PLACES_LocalData_for_BetterHealth/FeatureServer/0"
)

arc_open(furl)

# Table
furl <- paste0(
  "https://services.arcgis.com/P3ePLMYs2RVChkJx/arcgis/rest/services/",
  "USA_Wetlands/FeatureServer/1"
)

arc_open(furl)

# ImageServer
arc_open(
  "https://landsat2.arcgis.com/arcgis/rest/services/Landsat/MS/ImageServer"
)

# FeatureServer
furl <- paste0(
  "https://services3.arcgis.com/ZvidGQkLaDJxRSJ2/arcgis/rest/services/",
  "PLACES_LocalData_for_BetterHealth/FeatureServer"
)

arc_open(furl)

# MapServer
map_url <- paste0(
  "https://services.arcgisonline.com/ArcGIS/rest/services/",
  "World_Imagery/MapServer"
)

arc_open(map_url)
}
}
\seealso{
arc_select arc_raster get_layer
}
