% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_lcUnconditionals.R
\name{apollo_lcUnconditionals}
\alias{apollo_lcUnconditionals}
\title{Returns unconditionals for a latent class model model}
\usage{
apollo_lcUnconditionals(model, apollo_probabilities, apollo_inputs)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters.
  \item \strong{\code{apollo_inputs}}: List containing options of the model. See \link{apollo_validateInputs}.
  \item \strong{\code{functionality}}: Character. Can be either \strong{\code{"components"}}, \strong{\code{"conditionals"}}, \strong{\code{"estimate"}} (default), \strong{\code{"gradient"}}, \strong{\code{"output"}}, \strong{\code{"prediction"}}, \strong{\code{"preprocess"}}, \strong{\code{"raw"}}, \strong{\code{"report"}}, \strong{\code{"shares_LL"}}, \strong{\code{"validate"}} or \strong{\code{"zero_LL"}}.
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}
}
\value{
List of object, one per random component and one for the class allocation probabilities.
}
\description{
Returns values for random parameters and class allocation probabilities in a latent class model model.
}
