% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSimulation.R
\name{runSimulation}
\alias{runSimulation}
\title{Run an Antares Simulation}
\usage{
runSimulation(
  name,
  mode = "economy",
  path_solver = getOption("antares.solver"),
  wait = TRUE,
  show_output_on_console = FALSE,
  parallel = TRUE,
  ...,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{name}{Name of the simulation. In API mode, \code{name} will be used as \code{output_suffix} argument.}

\item{mode}{Simulation mode, can take value "economy", "adequacy" or "draft".}

\item{path_solver}{Character containing the Antares Solver path}

\item{wait}{Logical, indicating whether the R interpreter should wait for the
simulation to finish, or run it asynchronously.}

\item{show_output_on_console}{Logical, indicating whether to capture the ANTARES log and show
it on the R console.}

\item{parallel}{Logical. If \code{TRUE} the ANTARES simulation will be run in parallel mode (Work
only with ANTARES v6.0.0 or more). In that case, the number of cores used by the simulation
is the one set in advanced_settings/simulation_cores (see ANTARES interface).}

\item{...}{Additional arguments (API only), such as \code{nb_cpu}, \code{time_limit}, ...
See API documentation for all available options.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
In API mode it return a \code{list} with either the job id in case of success of
the command or details about the error produce.
In non-API mode the function does not return anything, it is  used to launch an
ANTARES simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Run an ANTARES study
}
