% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose_split.R
\name{expose_split}
\alias{expose_split}
\alias{is_split_exposed_df}
\title{Split calendar exposures by policy year}
\usage{
expose_split(.data)

is_split_exposed_df(x)
}
\arguments{
\item{.data}{An \code{exposed_df} object with calendar period exposures.}

\item{x}{Any object}
}
\value{
For \code{expose_split()}, a tibble with class \code{split_exposed_df},
\code{exposed_df}, \code{tbl_df}, \code{tbl}, and \code{data.frame}. The results include all
columns in \code{.data} except that \code{exposure} has been renamed to \code{exposure_cal}.
Additional columns include:
\itemize{
\item \code{exposure_pol} - policy year exposures
\item \code{pol_yr} - policy year
}

For \code{is_split_exposed_df()}, a length-1 logical vector.
}
\description{
Split calendar period exposures that cross a policy anniversary
into a pre-anniversary record and a post-anniversary record.

After splitting the data, the resulting data frame will contain both calendar
exposures and policy year exposures. These columns will be named
\code{exposure_cal} and \code{exposure_pol}, respectively. Calendar exposures will be
in the original units passed to \code{expose_split()}. Policy exposures will
always be expressed in years.

After splitting exposures, downstream functions like \code{exp_stats()} and
\code{exp_shiny()} will require clarification as to which exposure basis should
be used to summarize results.

\code{is_split_exposed_df()} will return \code{TRUE} if \code{x} is a \code{split_exposed_df}
object.
}
\details{
\code{.data} must be an \code{exposed_df} with calendar year, quarter, month,
or week exposure records. Calendar year exposures are created by the
functions \code{\link[=expose_cy]{expose_cy()}}, \code{\link[=expose_cq]{expose_cq()}}, \code{\link[=expose_cm]{expose_cm()}}, or \code{\link[=expose_cw]{expose_cw()}}, (or
\code{\link[=expose]{expose()}} when \code{cal_expo = TRUE}).
}
\examples{
toy_census |> expose_cy("2022-12-31") |> expose_split()

}
\seealso{
\code{\link[=expose]{expose()}} for information on creating exposure records from census
data.
}
