% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity.summary.by.period.R
\name{activity.summary.by.window.duration}
\alias{activity.summary.by.window.duration}
\title{Summarise activity data from a folder of activPAL events files
into equal sized periods}
\usage{
activity.summary.by.window.duration(input_folder, output_folder,
  window_duration = 2)
}
\arguments{
\item{input_folder}{The filepath for the folder where the events files (format *Events.csv)
to be processed are saved}

\item{output_folder}{The filepath for the folder where the csv summary files are to be saved}

\item{window_duration}{The size of each bucket in hours that the data is to be summarised.
Default - 2 hours.}
}
\description{
activity.summary.window processes all the events files (format *Events.csv)
    in a folder and produces a summary table giving a breakdown of the number and
    duration of each event type across consecutive periods of a specified duration
    during the day. If the window_size is not a factor of 24, the final period will
    be shorter than the other reporting periods, generating a warning to advise of
    this difference in reporting period duration.  The generated summary activity
    table for each events file is saved to a csv file, while an additional csv file
    containing the summaries across all the processed events files is also saved.
}
\examples{
input_folder <- paste(system.file("extdata", "", package = "activPAL"),"/",sep="")
output_folder <- paste(tempdir(),"/",sep="")

activPAL::activity.summary.by.window.duration(input_folder,output_folder,2)

# Omitting a value for window_duration sets the default window size to 2 hours
activPAL::activity.summary.by.window.duration(input_folder,output_folder)

# You can set the window_duration to a time period that is not evenly divisible
# by 24 hours.  In this case the last reporting period for each day will be
# shorter than the specified window_duration.
activPAL::activity.summary.by.window.duration(input_folder,output_folder,3.5)
}
