% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode-utils.r
\name{split_geocodes}
\alias{split_geocodes}
\alias{bind_geocodes}
\title{Split or bind geocodes}
\usage{
split_geocodes(geocode, idx = "spct.idx", simplify = TRUE)

bind_geocodes(geocode, idx = "spct.idx")
}
\arguments{
\item{geocode}{data.frame with geocode data in columns \code{"lat"},
\code{"lon"}, and possibly also \code{"address"}.}

\item{idx}{character Name of the column where the ID factor is stored
in geocode data frames with multiple rows.}

\item{simplify}{logical Flag indicating if when the list to be returnes
has a single member, the member geocode should be returned instead.}
}
\value{
A list of geo_code data frames or a single geocode data frame.
}
\description{
Multiple geocodes can be stored as rows in a single data frame or as a
named list of one row data frames. As metadata attributes lists are easier
to manipulate, but when computing the sun position data frames are more
efficient. These functions implement conversions between objects using
these two approaches.
}
\details{
Function \code{split_geocodes()} splits a multi-row data.frame
  containing one geocode per row and a \code{character} vector or a
  \code{factor} as ID column into a named list of one row data
  frames containing the same geocode information. If the input is a
  single-row data frame or a list with a single member, and
  \code{simplify = TRUE} is passed in the call, a bare data frame is
  returned, with the ID column, if present, deleted.

  Function \code{bind_geocodes()} binds the geocodes members of a
  list into a multirow data.frame containing one geocode per row and
  a \code{character} vector ID column containing the same geocode
  information.
}
\examples{
my.geocodes <- data.frame(lon = c(0, 10, 15),
                          lat = c(30, 60, 89),
                          address = c("one", "two", "three"),
                          spct.idx = c("A", "B", "C"))

split_geocodes(my.geocodes)
split_geocodes(my.geocodes[1, ])

my.list <- list("A" = data.frame(lon = 10,
                                 lat = 30,
                                 address = "North"),
                "B" = data.frame(lon = -10,
                                 lat = -30,
                                 address = "South"))

bind_geocodes(my.list)

}
