% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kTrimMean.R
\name{kTrimMean}
\alias{kTrimMean}
\title{Compute Trimmed-k Mean}
\usage{
kTrimMean(dat, k)
}
\arguments{
\item{dat}{A numeric vector of data.}

\item{k}{An integer indicating how many smallest and largest values to trim.}
}
\value{
The trimmed-k mean of the data. Returns NA if not enough data points.
}
\description{
This function calculates the trimmed-k mean of a numeric vector by removing the k smallest and k largest values.
}
\examples{
set.seed(5400)
dat <- rexp(20, rate = 0.5)
kTrimMean(dat, k = 2)
}
