% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DimList2Hierarchy.R
\name{DimList2Hrc}
\alias{DimList2Hrc}
\alias{Hrc2DimList}
\title{DimList2Hrc/Hrc2DimList}
\usage{
DimList2Hrc(dimList)

Hrc2DimList(hrc, total = "Total")
}
\arguments{
\item{dimList}{List of data frames according to the specifications in sdcTable}

\item{hrc}{List of character vectors}

\item{total}{String used to name totals.}
}
\value{
See Arguments
}
\description{
Conversion between hierarchies/dimList as in sdcTable and TauArgus coded hierarchies
}
\examples{
# First generate dimList
dimList <- FindDimLists(SSBtoolsData("sprt_emp_withEU")[, c("geo", "eu", "age")])
dimList
hrc <- DimList2Hrc(dimList)
hrc
dimList2 <- Hrc2DimList(hrc)
identical(dimList, dimList2)
}
\seealso{
\code{\link{DimList2Hierarchy}}, \code{\link{Hierarchy2Formula}}, \code{\link{AutoHierarchies}}.
}
\author{
Øyvind Langsrud
}
