% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{reduce_dimensionality}
\alias{reduce_dimensionality}
\title{Dimensionality reduction}
\usage{
reduce_dimensionality(
  x,
  dist = c("spearman", "pearson", "euclidean", "cosine", "manhattan"),
  ndim = 3,
  num_landmarks = 1000
)
}
\arguments{
\item{x}{a numeric matrix}

\item{dist}{the distance metric to be used; can be any of the metrics listed in \code{\link[dynutils:calculate_distance]{dynutils::calculate_distance()}}.}

\item{ndim}{the maximum dimension of the space which the data are to be represented in; must be in \eqn{[1, n - 1]}, with \eqn{n} the number of samples (rows) in \code{x}.}

\item{num_landmarks}{the number of landmarks to be selected.}
}
\value{
A matrix containing the coordinates of each sample, represented in an \code{ndim}-dimensional space.
}
\description{
\code{reduce_dimensionality} performs an eigenanalysis of the given dissimilarity matrix
and returns coordinates of the samples represented in an \code{ndim}-dimensional space.
}
\examples{
## Generate an example dataset
dataset <- generate_dataset(num_genes = 200, num_samples = 400, num_groups = 4)

## Reduce the dimensionality of this dataset
space <- reduce_dimensionality(dataset$expression, ndim = 2)

## Visualise the dataset
draw_trajectory_plot(space, progression_group = dataset$sample_info$group_name)
}
\seealso{
\link{SCORPIUS}
}
