# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Internal function: Quantile Regression with Adaptively Group Lasso with `Omega`
#' @keywords internal
#' 
#' @description Internal function: Quantile regression with adaptively group Lasso with `Omega`.
#' @param Y Data matrix (\eqn{n \times 1}).
#' @param W B-splines with covariates matrix with \eqn{p \times L} columns and \eqn{n} rows.
#' @param omega Weights for group lasso.
#' @param lambda A sequence of tuning parameters.
#' @param tau A quantile of interest.
#' @param qn A bound parameter for HDIC.
#' @param zeta A step parameter.
#' @param zetaincre An increment of each step.
#' @param maxit The maximum number of iterations.
#' @param tol A tolerance rate. 
#' @return A list of selected parameters.
awgl_omega <- function(Y, W, omega, lambda, tau, qn, zeta, zetaincre, maxit, tol) {
    .Call(`_QuantRegGLasso_awgl_omega`, Y, W, omega, lambda, tau, qn, zeta, zetaincre, maxit, tol)
}

#' @title Internal function: Quantile Regression with Adaptively Group Lasso without `Omega`
#' @keywords internal
#' 
#' @description Internal function: Quantile regression with adaptively group Lasso without `Omega`.
#' @param Y Data matrix (\eqn{n \times 1}).
#' @param W B-splines with covariates matrix with \eqn{p \times L} columns and \eqn{n} rows.
#' @param lambda A sequence of tuning parameters.
#' @param tau A quantile of interest.
#' @param L The number of groups.
#' @param qn A bound parameter for HDIC.
#' @param zeta A step parameter.
#' @param zetaincre An increment of each step.
#' @param maxit The maximum number of iterations.
#' @param tol A tolerance rate. 
#' @return A list of selected parameters.
awgl <- function(Y, W, lambda, tau, L, qn, zeta, zetaincre, maxit, tol) {
    .Call(`_QuantRegGLasso_awgl`, Y, W, lambda, tau, L, qn, zeta, zetaincre, maxit, tol)
}

