% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcReliability.R
\name{calcReliability}
\alias{calcReliability}
\title{Calculate reliability of quality measure performance}
\usage{
calcReliability(
  df = NULL,
  model = NULL,
  entity = "entity",
  y = "y",
  data.type = "binary",
  show.all = FALSE,
  ctrPerf = controlPerf(),
  ctrRel = controlRel()
)
}
\arguments{
\item{df}{observation-level data; if null, will use the dataframe from the model object}

\item{model}{model; if null, will use an unadjusted model}

\item{entity}{data column containing the accountable entity identifier}

\item{y}{data column containing the outcome variable}

\item{data.type}{acceptable values are \code{binary} for 0/1 data and \code{continuous} for continuous data (default: \code{binary})}

\item{show.all}{logical indicator for whether full list of reliability method estimates should be calculated (default: \code{FALSE})}

\item{ctrPerf}{parameters to control performance measure calculation}

\item{ctrRel}{parameters to control reliability estimation}
}
\value{
A list with reliability estimates. \code{rel.results} is a dataframe summarizing estimates from the various methods. Output from each method's respective function is also included.
More details on output from each method can be found within the help documentation for the respective function for that method. For example, see \code{\link[=calcSSR]{calcSSR()}} for more detail on \code{SSR.out}.
}
\description{
This function calculates several estimates of quality measure performance.
}
\examples{
### Simulate data with binary outcome
df <- simulateData(n.entity = 50, n.obs = 100, mu = .2, r = .7)

# Calculate reliability
out <- calcReliability(df = df, entity = 'entity', y = 'y', ctrRel = controlRel(n.resamples = 10))

# Plot estimates
plotReliability(out)


}
\references{
Nieser KJ, Harris AH. Comparing methods for assessing the reliability of health care quality measures. Statistics in Medicine. 2024 Oct 15;43(23):4575-94.
}
\seealso{
\code{\link[=calcAOV]{calcAOV()}}, \code{\link[=calcBetaBin]{calcBetaBin()}}, \code{\link[=calcHLGMRel]{calcHLGMRel()}}, \code{\link[=calcHLMRel]{calcHLMRel()}}, \code{\link[=calcResamplingIUR]{calcResamplingIUR()}}, \code{\link[=calcSSR]{calcSSR()}}
}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
