% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization.R
\name{run_param_grid}
\alias{run_param_grid}
\title{Run Parameter Grid Optimization (safe + ergonomic)}
\usage{
run_param_grid(
  prices,
  grid,
  builder,
  metric = NULL,
  name_prefix = "Strategy",
  verbose = FALSE,
  light_mode = TRUE,
  precompute_returns = TRUE,
  builder_args = list(),
  n_cores = 1,
  fixed = NULL
)
}
\arguments{
\item{prices}{Data frame with Date + symbol columns}

\item{grid}{Data frame (each row = a combo) OR a \strong{named list} of vectors}

\item{builder}{Function(prices, params, ...) -> weights (Date + symbols)}

\item{metric}{Scoring function(backtest) -> numeric. Defaults to metric_sharpe.}

\item{name_prefix}{String prefix for backtest names}

\item{verbose}{Logical}

\item{light_mode}{Logical: speed-ups in backtest}

\item{precompute_returns}{Logical: precompute log-returns once (light_mode only)}

\item{builder_args}{List of extra args forwarded to builder (e.g., caches)}

\item{n_cores}{Integer (kept for API compatibility; ignored here)}

\item{fixed}{Optional named list of \strong{constant} parameters merged into every combo.
If a name appears in both \code{grid} and \code{fixed}, the \strong{fixed value wins} and that
column is \strong{pruned from the grid} (fewer duplicate combos; clearer counts).}
}
\value{
param_grid_result
}
\description{
Run Parameter Grid Optimization (safe + ergonomic)
}
